<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for tabs
*
* @package	postbit
*/
class vBDownloads_DataManager_Comment extends vB_DataManager
{
	/**
	* Array of recognised and required fields for tabs, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'commentid' 	=> array(TYPE_UINT, 	REQ_INCR, 	VF_METHOD, 	'verify_nonzero'),
		'userid' 		=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD),
		'downloadid' 	=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD),
		'comment' 		=> array(TYPE_STR, 		REQ_YES),
		'dateline' 		=> array(TYPE_UNIXTIME, REQ_AUTO),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_downloads_comment';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('commentid = \'%1$s\'', 'commentid');

	/**
	* Verifies that the commentid is valid
	*
	* @param	string	commentid
	*
	* @return	boolean
	*/
	function verify_downloadid(&$downloadid)
	{
		// Validate offon
		return (count(VBDOWNLOADS::$db->fetchRow('SELECT downloadid FROM $dbtech_downloads_download WHERE downloadid = ?', array($downloadid))) == 1);
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		global $vbphrase;

		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_commentdata_presave')) ? eval($hook) : false;		

		if ($this->condition === null OR !$this->fetch_field('dateline'))
		{
			// Set dateline
			$timenow = TIMENOW;
			$this->do_set('dateline', $timenow);
		}

		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_commentdata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_commentdata_postsave')) ? eval($hook) : false;

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_commentdata_delete')) ? eval($hook) : false;
		
		return true;
	}
}